function deliverSound(ISI,ampLev,nMovs)

%% Sound properties

soundDuration = 0.003; % in seconds
soundFrequency = 900; % in Hz
nSecs = 1; % length of movie in seconds

%% Set up DAQ connection

s = daq.createSession('ni');
s.Rate = 100000;
ch1 = s.addAnalogOutputChannel('Dev1',0,'Voltage'); % speaker 1
ch2 = s.addAnalogOutputChannel('Dev1',1,'Voltage'); % speaker 2
ch3 = s.addAnalogOutputChannel('Dev1',2,'Voltage'); % camera


%% Set up camera connection
a=10; % amplitude
fps= 29.7; % frequency (fps)
dc=10; % duty cycle (1 to 100)
f=fps*2*pi;
nSecs = nSecs; % length of movie in seconds
scans = s.Rate*nSecs;
timeInScans = linspace(0,nSecs,scans);
cameraTriggers=[0 a*square(f*timeInScans,dc)];
cameraTriggers(end)=[];

imaqmem(2e16)
vid = videoinput('dcam',1,'F7_Y8_1388x1040');
vid.LoggingMode = 'memory';
src = getselectedsource(vid);
% diskLogger = VideoWriter('test', 'Motion JPEG AVI');
% vid.DiskLogger = diskLogger;
vid.ReturnedColorSpace = 'grayscale';
vid.FramesPerTrigger = 1; % 
% vid.TriggerRepeat = floor(nSecs*f);
vid.TriggerRepeat = (fps*nSecs)-1; % number frames minus one nSecs*fps-1
vid.Timeout = 2;
src.GainMode = 'manual';
src.AutoExposure = 0;
src.Gain = 105; 
src.ShutterMode = 'manual';
src.Shutter = 1050;
triggerconfig(vid, 'hardware', 'risingEdge', 'externalTriggerMode0-Source0');
% triggerconfig(vid, 'immediate');
src.TriggerParameter = 1;

%% set up sound

soundT = (1:(soundDuration*s.Rate))/s.Rate;
soundOutput = square(2*pi*soundFrequency*soundT);
soundpreFiller = zeros(1,63974);
soundpostFiller = zeros(1,length(cameraTriggers)-length(soundpreFiller)-length(soundOutput));
soundOutputEdit = [soundpreFiller ampLev*soundOutput soundpostFiller];



for movieNumber = 1:nMovs
    movieNumber
tic   
tic;

fid = sprintf('mov%d',movieNumber);

outputData(:,1) = soundOutputEdit;
outputData(:,2) = soundOutputEdit;
outputData(:,3) = cameraTriggers';
s.queueOutputData(outputData)
% preview(vid)

start(vid)
s.startForeground;

diskLogger = VideoWriter(fid, 'Motion JPEG avi');
open(diskLogger);
[data time] = getdata(vid, vid.FramesAvailable);

numFrames = size(data, 4);
for r = 1:numFrames 
    writeVideo(diskLogger, data(:,:,:,r));
end
close(diskLogger);
elapsedT = toc;

pause(ISI-elapsedT)
toc
end
stop(vid)
clear vid
close all

end
