function recordMovie(movLength,fname)
% pause(60)
imaqreset

imaqreset
s = daq.createSession('ni');
ch1 = s.addAnalogOutputChannel('Dev1',2,'Voltage'); % camera

a = 10; % amplitude
f= 29.75; % frequency (fps)
dc=50; % duty cycle (1 to 100)
f=f*2*pi;
nSecs = movLength; % length of movie in seconds
scans = s.Rate*nSecs;
timeInScans = linspace(0,nSecs,scans);
y=a*square(f*timeInScans,dc);
% plot(timeInScans,y);
% axis([-0.5 240.5 -10.4 10.4]);
imaqmem(2e16)
vid = videoinput('dcam',1,'F7_Y8_1388x1040');
vid.LoggingMode = 'disk';
vid.DiskLogger = VideoWriter(fname, 'Motion JPEG AVI');
%preview(vid)
src = getselectedsource(vid);
% diskLogger = VideoWriter('test', 'Motion JPEG AVI');
% vid.DiskLogger = diskLogger;
vid.ReturnedColorSpace = 'grayscale';
vid.FramesPerTrigger = 1; % 
vid.TriggerRepeat = (10*nSecs)-1; % number frames minus one nSecs*fps-1
vid.Timeout = 1000;
src.GainMode = 'Manual';
src.AutoExposure = 0;
src.Gain = 105; 
src.ShutterMode = 'manual';
src.Shutter = 1050;
triggerconfig(vid, 'hardware', 'fallingEdge', 'externalTriggerMode4-Source0');
src.TriggerParameter = 1;

outputData(:,1) = y;
% outputData(:,2) = [repmat(0,1,scans/2) repmat(10,1,scans/2-1) repmat(0,1,1)]';
% plot(1:240000,outputData(:,2))
s.queueOutputData(outputData)
% preview(vid)
start(vid)
s.startForeground;
wait(vid)
stop(vid)
close all


