clearvars -except mask
cd('E:\Documents\MATLAB') % set appropriately
[FileName,PathName] = uigetfile('Select Mask');
load([PathName FileName])
numwells = 48;
inds = zeros(10,numwells);

nExps = inputdlg('# of experiments to analyze');

for expN = 1:str2num(nExps{1})
   expFolds{expN} = uigetdir('E:\Documents\MATLAB\'); % set appropriately
end

ratios = [];
for y = 1:length(expFolds)
    directName = expFolds{y};
    d = dir(directName);
    isub = [d(:).isdir]; %# returns logical vector
    nameFolds = {d(isub).name}';
    nameFolds(ismember(nameFolds,{'.','..'})) = [];
    cd(directName)
    currPath = cd;
    
    for nfolder = 1:length(nameFolds)
    cd([currPath '\' nameFolds{nfolder}] )
    movFiles = dir('*.avi');
        for movN = 1:length(movFiles)
            movN
            
        vidfile = movFiles(movN).name;
        vidfile
        if length(vidfile)==8;
        vidN = str2num(vidfile(4:5));
        elseif length(vidfile)==9;
        vidN = str2num(vidfile(4:6));
        elseif length(vidfile)==10;
        vidN = str2num(vidfile(4:7));            
        end
        vidN;
        obj = VideoReader(vidfile);
        f = read(obj);
        numframes = size(f,4);
        for j = 1:numwells
            [X,Y] = find(mask==j+1);
                for k = 1:numframes
                    p = f(:,:,1,k);
                    he(:,:,k) = p(min(X):max(X),min(Y):max(Y));      
                end
            for e = 1:18;        
            difference = im2bw(imabsdiff(he(:,:,e),he(:,:,e+1)),(16/255));
            bgDiffs(j,e) = sum(difference(:));
            clear difference
            end              
        clear he 
        end
        bgDiffsPerMov{vidN}=bgDiffs;
        clear bgDiffs
        end
    bgDiffersPerFold{nfolder}=bgDiffsPerMov;
    clear bgDiffsPerMov
    end
    
    distPerWell = [];
    for u =1:length(bgDiffersPerFold)
        xx = bgDiffersPerFold{u};
        rr=[];
        for yy = 1:length(xx)           
            rr=horzcat(rr,xx{:,yy});
        end
    distPerWell = horzcat(distPerWell,rr);
    clear rr
    end
    
    clear difference
    %%%%%
    
    for nfolder = 1:length(nameFolds)
    cd([currPath '\' nameFolds{nfolder}] )
    movFiles = dir('*.avi');
        for movN = 1:length(movFiles)
            movN
        vidfile = movFiles(movN).name;
                
        vidfile
        if length(vidfile)==8;
        vidN = str2num(vidfile(4:5));
        elseif length(vidfile)==9;
        vidN = str2num(vidfile(4:6));
        elseif length(vidfile)==10;
        vidN = str2num(vidfile(4:7));            
        end
        
        obj = VideoReader(vidfile);
        f = read(obj);
        numframes = size(f,4);
            for j = 1:numwells
                [X,Y] = find(mask==j+1);
                    for k = 1:numframes
                        pe = f(:,:,1,k);
                        he(:,:,k) = pe(min(X):max(X),min(Y):max(Y));      
                    end
                    clear pe
                    for e = 20:21;
                    difference = im2bw(imabsdiff(he(:,:,e),he(:,:,e+1)),(16/255));
                    difference2(e-19) = sum(difference(:));
                    end
                escapeDiff = max(difference2(:));
                [h,p]=ttest2(distPerWell(j,:),escapeDiff);
                clear escapeDiff
                    if p<0.01
                    escapes(vidN,j)=1;  
                    else
                    escapes(vidN,j)=0;  
                    end
                clear difference p he        
            end
        end
        save('escapesLong','escapes')
        clear escapes
    end
    
    
end


for y = 1:length(expFolds)
    directName = expFolds{y};
    d = dir(directName);
    isub = [d(:).isdir]; %# returns logical vector
    nameFolds = {d(isub).name}';
    nameFolds(ismember(nameFolds,{'.','..'})) = [];
    cd(directName)
    currPath = cd;
    
    habs = strncmp('5 ISI, 0.4 volts, 100 movies',nameFolds,20);
    habfolder = nameFolds(habs);
    habfolder2 = strcat(currPath,'\',habfolder);
    cd(habfolder2{1})
    load('escapesLong')
    fHab = escapes;
    cd ..
    his = strncmp('90 ISI, 0.4 volts, 10 movies',nameFolds,20);
    hisfolder = nameFolds(his);
    hisfolder2 = strcat(currPath,'\',hisfolder);
    cd(hisfolder2{1})
    load('escapesLong')
    fHi = escapes;
    oo = repmat([1], 1, 48);
    uu = 1;
    
    hi = mean(fHi(:,oo==uu));
    hab = fHab(:,oo==uu);
    %%%
    inds2keep = hi > -1;
    wellNums = find(inds2keep==uu);
    %%%
    habLast60 = hab(:,inds2keep);
    %plot(1:57,mean(habLast60'));
    means(uu) = mean(mean(fHab(:,oo==uu)'));
    HIscores = [(1-mean(habLast60(60:100,:))./hi(inds2keep))' wellNums'];
    % HIscores = [(1-mean(habLast60(60:100,:))./hi(inds2keep))'];
    HIscores(:,3)=hi';
    HI{uu}=HIscores;
    
    cd(currPath)
    save('HIscores.mat','HIscores')
    
end
clearvars -except fHab fHi HIscores escapes

%HIscore: first column shows habituation index. second column shows the index of individual fish third column shows probability of escape during the first 10
%stimuli of series. 
%escapes: shows escapes during the first 10 stimuli at 90 seconds interstimulus interval. 1 = escape; 0 = no escape; fish are ordered by column and sound
%stimuli by line
%fHab: shows escapes during the 100 stimuli at 5 seconds interstimulus interval. 1 = escape; 0 = no escape; fish are ordered by column and sound
%stimuli by line
%fHi: same as escapes


 save('HIscores.mat','HIscores', 'fHab', 'fHi', 'escapes')