imaqreset; clear

%% Spontaneous activity recording settings

acclimationTime = 900; %in seconds
movLength = 600; % duration of spontaneous activity recording in seconds
filename = inputdlg('Name','Experiment name'); 

%% Protocol Settings

% %classic
nTrials = 2; % number of sound stimulus trials
InterStimInterval = [90 5]; % Interstimulus interval in seconds / number of columns should be nTrials
amplitude = [0.4 0.4]; % voltage outputs / number of columns should be nTrials
nMovies = [10 100]; % number of stimuli / movies / number of columns should be nTrials


%% Set up file directory

cd('E:\Documents\MATLAB\') % set appropriately
clockstr = clock;
todaystr = sprintf('%4d-%02d-%02d',clockstr(1:3));
try cd(todaystr)
catch
  mkdir(todaystr)
  cd(todaystr)
end
gd.filepath = ['E:\Documents\MATLAB\' todaystr,'\']; % set appropriately

% fname = filename{1};
mkdir(fname)
cd(fname)

pause(acclimationTime);
recordMovie(movLength,fname)

for trialNo = 1:nTrials
    ISI = InterStimInterval(trialNo);
    movNo = nMovies(trialNo);
    soundLevel = amplitude(trialNo);
    
    foldname = [num2str(ISI) ' ISI, ' num2str(soundLevel) ' volts, ' num2str(movNo) ' movies'];
    mkdir(foldname)
    cd(foldname)
    deliverSound(ISI,soundLevel,movNo);
    cd ..
    
end


