function makeAndSaveROI(numRows, numCols);
% takes a bunch of different values, makes an ROI, and saves it to the
% appropriate location.

global ROI

% try to load the parameters from last time
try load E:\Documents\MATLAB
catch
  ROI.numRows = numRows;
  ROI.numCols = numCols;
  ROI.width = 100;
  ROI.height = 100;
  ROI.xoffset = 42;
  ROI.yoffset = 32;
  ROI.xspacing = 5;
  ROI.yspacing = 5;
  ROI.imageHeight = 1040;
  ROI.imageWidth = 1388;
  save('E:\Documents\MATLAB\ROIparams.mat','ROI')
end

% set up the figure to take user input
ROI.ROIfigure.handle = figure('Toolbar','none',...
  'Menubar', 'none',...
  'NumberTitle','Off',...
  'Name','makeAndSaveROI',...
  'Position',[1600 250 300 400]);

% ROI Width & Height
ROI.ROIfigure.ROIwidth.handle = uicontrol(ROI.ROIfigure.handle,'Style','edit',...
    'Position',[10 350 40 30],'FontSize',16,'String',num2str(ROI.width));
ROI.ROIfigure.ROIwidthtext.handle = uicontrol(ROI.ROIfigure.handle,'Style','text',...
    'String','Well size','Position',[60 350 120 30],...
    'FontSize',16,'HorizontalAlignment','left');

% ROI Height
%ROI.ROIfigure.ROIheight.handle = uicontrol(ROI.ROIfigure.handle,'Style','edit',...
    %'Position',[10 315 40 30],'FontSize',16,'String',num2str(ROI.height));
%ROI.ROIfigure.ROIHeighttext.handle = uicontrol(ROI.ROIfigure.handle,'Style','text',...
    %'String','Well height','Position',[60 315 120 30],...
    %'FontSize',16,'HorizontalAlignment','left');

% Horizontal offset
ROI.ROIfigure.ROIxoffset.handle = uicontrol(ROI.ROIfigure.handle,'Style','edit',...
    'Position',[10 260 40 30],'FontSize',16,'String',num2str(ROI.xoffset));
ROI.ROIfigure.ROIxoffsettext.handle = uicontrol(ROI.ROIfigure.handle,'Style','text',...
    'String','Horizontal offset','Position',[60 260 200 30],...
    'FontSize',16,'HorizontalAlignment','left');

% Vertical offset
ROI.ROIfigure.ROIyoffset.handle = uicontrol(ROI.ROIfigure.handle,'Style','edit',...
    'Position',[10 225 40 30],'FontSize',16,'String',num2str(ROI.yoffset));
ROI.ROIfigure.ROIyoffsettext.handle = uicontrol(ROI.ROIfigure.handle,'Style','text',...
    'String','Vertical offset','Position',[60 225 200 30],...
    'FontSize',16,'HorizontalAlignment','left');

% Horizontal Spacing
ROI.ROIfigure.ROIxspacing.handle = uicontrol(ROI.ROIfigure.handle,'Style','edit',...
    'Position',[10 170 40 30],'FontSize',16,'String',num2str(ROI.xspacing));
ROI.ROIfigure.ROIxspacingtext.handle = uicontrol(ROI.ROIfigure.handle,'Style','text',...
    'String','Horizontal spacing','Position',[60 170 200 30],...
    'FontSize',16,'HorizontalAlignment','left');

% Vertical Spacing
ROI.ROIfigure.ROIyspacing.handle = uicontrol(ROI.ROIfigure.handle,'Style','edit',...
    'Position',[10 135 40 30],'FontSize',16,'String',num2str(ROI.yspacing));
ROI.ROIfigure.ROIyspacingtext.handle = uicontrol(ROI.ROIfigure.handle,'Style','text',...
    'String','Vertical spacing','Position',[60 135 200 30],...
    'FontSize',16,'HorizontalAlignment','left');

% Some text to report what is going on
ROI.ROIfigure.ROIstatustext = uicontrol(ROI.ROIfigure.handle,'Style','text',...
  'String','Input parameters, then press "Make ROI"','FontSize',14,...
  'Position',[10 70 280 50]);

% and two buttons
ROI.ROIfigure.ROImakebutton = uicontrol(ROI.ROIfigure.handle,'Style','pushbutton',...
  'String','Make ROI','Position',[10 10 130 50],'FontSize',18,'Callback',@processInput);
ROI.ROIfigure.ROIquit = uicontrol(ROI.ROIfigure.handle,'Style','pushbutton',...
  'String','Quit','Position',[160 10 130 50],'FontSize',18,'Callback',@closeAndQuit);

function closeAndQuit(hObject,eventData,handles) % exits the program
global ROI
save('E:\Documents\MATLAB\ROIparams.mat','ROI')
close(ROI.ROIfigure.handle)
%exit

function processInput(hObject,eventData,handles) % makes sure all the input is kosher
global ROI

try ROI.width = fix(str2num(get(ROI.ROIfigure.ROIwidth.handle,'String')));
  ROI.height = ROI.width;
catch
  set(ROI.ROIfigure.ROIstatustext,'String','Well size must be numeric')
  return;
end

%try ROI.height = fix(str2num(get(ROI.ROIfigure.ROIheight.handle,'String')));
%catch
%  set(ROI.ROIfigure.ROIstatustext,'String','Well height must be numeric')
%  return;
%end

try ROI.xoffset = fix(str2num(get(ROI.ROIfigure.ROIxoffset.handle,'String')));
catch
  set(ROI.ROIfigure.ROIstatustext,'String','Horizontal offset must be numeric')
  return;
end

try ROI.yoffset = fix(str2num(get(ROI.ROIfigure.ROIyoffset.handle,'String')));
catch
  set(ROI.ROIfigure.ROIstatustext,'String','Vertical offset must be numeric')
  return;
end

try ROI.xspacing = fix(str2num(get(ROI.ROIfigure.ROIxspacing.handle,'String')));
catch
  set(ROI.ROIfigure.ROIstatustext,'String','Horizontal spacing must be numeric')
  return;
end

try ROI.yspacing = fix(str2num(get(ROI.ROIfigure.ROIyspacing.handle,'String')));
catch
  set(ROI.ROIfigure.ROIstatustext,'String','Vertical spacing must be numeric')
  return;
end

% error checking
if ( ROI.height*ROI.numRows + ROI.yspacing*ROI.numRows + ROI.yoffset ) > ROI.imageHeight 
  set(ROI.ROIfigure.ROIstatustext,'String','Can''t fit all rows')
  return;
elseif ( (ROI.width-1)*ROI.numCols + ROI.xspacing*ROI.numCols + ROI.xoffset ) > ROI.imageWidth 
  set(ROI.ROIfigure.ROIstatustext,'String','Can''t fit all columns')
 return;
end

set(ROI.ROIfigure.ROIstatustext,'String','Parameters OK; generating ROI')
generateROI

function generateROI % generates and saves an ROI mask
global ROI

colsOffset = ROI.yoffset;

% initial variables
n = 1;
mask = zeros(ROI.imageHeight,ROI.imageWidth);

% do the rows of wells
for coli = 1:ROI.numRows

  % start our row offset afresh for each row
  rowsOffset = ROI.xoffset;
  
  % set up each columns of wells
  for rowi = 1:ROI.numCols
    
    % do one well
    ROIindex = zeros(ROI.height*ROI.width,1);
    for i = 1:ROI.height 
      for j = 0:ROI.width - 1
        ROIindex((i-1)*ROI.height + (j+1)) = ((rowsOffset+j)*ROI.imageHeight) + i + colsOffset;
      end
    end
    
    mask(ROIindex) = n;
    n = n+1;
    
    % update yoffset for the next row
    rowsOffset = rowsOffset + ROI.xspacing + ROI.width;
    
  end
  % update xoffset for the next column
  colsOffset = colsOffset + ROI.yspacing + ROI.height;
end

% increment everything by 1 so that we have a positive value everywhere
mask = mask + 1;

save('E:\Documents\MATLAB\mask','mask');

set(ROI.ROIfigure.ROIstatustext,'String','ROI saved; input new parameters')

