function showContinuousVideo
% continuous video display functionality 
% used primarily for troubleshooting, setting the threshold and the ROI
% 2/4 added functionality to hold the most recent "x" frames from a given well
% in a variable called gd.video

global gd vid vidprops 

% load('ftestdel.mat')

imaqmem(2e10)
% initialize relevant variables
gd.fpsFreq = 30;
gd.numFrames = 1;
gd.wellToDisplay = 2; % MUST be greater than one
gd.threshold = 13/256;
load E:\Documents\MATLAB\mask % set appropriately
% load E:\Documents\MATLAB\Adam\96wellmaskblack\mask
gd.mask = mask;
gd.wellSize = sqrt(length(find(gd.mask == 2))); % relies on well width = well height

gd.numVideoFrames = 150;
gd.videoFrame = 1;
%gd.video = zeros(gd.wellSize,gd.wellSize,gd.numVideoFrames,'uint8');
gd.video = zeros(1040,1388,gd.numVideoFrames,'uint8');
gd.grabVideo = 0;
gd.videoTS = zeros(1,gd.numVideoFrames);

% set up video
imaqreset
vid = videoinput('dcam', 1, 'F7_Y8_1388x1040');
%vid = videoinput('fireiimaq', 1, 'VARIABLE_0 (1388X1040) Y_MONO');
vid.FramesPerTrigger = 1;
vid.FramesAcquiredFcn = @displayFramesContinuously; % call this function
vid.FramesAcquiredFcnCount = 1; % call evaluateFrame every n frames (so if we take every 30th frame, this is approx in seconds)
vid.FrameGrabInterval = 1; % take every nth frame from the camera into memory (camera runs ~30fps)
vid.ReturnedColorSpace = 'grayscale';
vid.TriggerRepeat = inf;
vid.TimeOut = 1;

vidprops = getselectedsource(vid);
% vidprops.GainMode = 'manual';
gd.vidprops.Gain = 105;
% vidprops.Gain = gd.vidprops.Gain;
% vidprops.ShutterMode = 'manual';
%%150
gd.vidprops.Shutter = 1168; % 3250 is just above 15fps 
% vidprops.Shutter = gd.vidprops.Shutter;


%% set up the figure
gd.showContinuousVideoFig.handle = figure('NumberTitle','Off',...
  'Menubar', 'none','Toolbar','none','Name','showContinuousVideo:Whole Dish',...
  'Position',[5 5 1585 1162],...
  'WindowButtonDownFcn',@updateWellToDisplay);
%...
%...
% here's an image to display what the camera sees
gd.startImage = getsnapshot(vid);
% gd.startImage = f;
gd.startImage = gd.startImage;
gd.showContinuousVideoImage.handle = imagesc(gd.startImage);



set(gca,'position',[0 0 1 1]);
colormap('gray')
axis off

hold on

% show the ROI mask as a transparent overlay
gd.showContinuousVideoROIAlpha.handle = image(cat(3,...
  0.3*ones(size(gd.startImage)),zeros(size(gd.startImage)),0.4*ones(size(gd.startImage))));
gd.ROIalphaData = zeros(size(gd.mask));
gd.ROIalphaData(gd.mask > 1) = .5;
set(gd.showContinuousVideoROIAlpha.handle,'AlphaData',gd.ROIalphaData);

% now, an alpha masked image to show the well we're currently viewing
gd.showContinuousVideoAlpha.handle = image(cat(3,...
  ones(size(gd.startImage)),zeros(size(gd.startImage)),zeros(size(gd.startImage))));
gd.alphaData = zeros(size(gd.startImage));
gd.alphaData(gd.mask == gd.wellToDisplay) = .5;
set(gd.showContinuousVideoAlpha.handle,'AlphaData',gd.alphaData);

% place some buttons and such in the figure
gd.showContinuousVideoFig.gainSliderText.handle = uicontrol(gd.showContinuousVideoFig.handle,'Style','text',...
  'String',['Gain = ' num2str(gd.vidprops.Gain)],'Position',[20 60 60 40]);
gd.showContinuousVideoFig.shutterSliderText.handle = uicontrol(gd.showContinuousVideoFig.handle,'Style','text',...
  'String',['Shutter = ' num2str(gd.vidprops.Shutter)],'Position',[100 60 60 40]);
gd.showContinuousVideoFig.gainSlider.handle = uicontrol(gd.showContinuousVideoFig.handle,'Style','slider',...
  'Max',850,'Min',150,'Value',150,'SliderStep',[.01 .2],'Position',[20 20 60 20],...
  'Callback',@setCameraGain);
gd.showContinuousVideoFig.shutterSlider.handle = uicontrol(gd.showContinuousVideoFig.handle,'Style','slider',...
  'Max',4095,'Min',5,'Value',1500,'SliderStep',[.01 .2],'Position',[100 20 60 20],...
  'Callback',@setCameraShutter);
gd.showContinuousVideoFig.startButton.handle = uicontrol(gd.showContinuousVideoFig.handle,'Style','pushbutton',...
  'String','Start',...
  'Position',[1475 80 85 20],...
  'Callback',@startCamera);
gd.showContinuousVideoFig.stopButton.handle = uicontrol(gd.showContinuousVideoFig.handle,'Style','pushbutton',...
  'String','Stop',...
  'Position',[1475 50 85 20],...
  'Callback',@stopCamera);
gd.showContinuousVideoFig.closeButton.handle = uicontrol(gd.showContinuousVideoFig.handle,'Style','pushbutton',...
  'String','Quit',...
  'Position',[1475 20 85 20],...
  'Callback',@closeAndDisconnect);
gd.showContinuousVideoFig.updateROI.handle = uicontrol(gd.showContinuousVideoFig.handle,'Style','pushbutton',...
  'String','Update ROI?','Position',[1350 20 100 20],...
  'Callback',@updateROIMask);

gd.showContinuousVideoFig.grabVideo.handle = uicontrol(gd.showContinuousVideoFig.handle,'Style','pushbutton',...
  'String','Grab Video?','Position',[1350 50 100 20],...
  'Callback',@grabVideo);
gd.showContinuousVideoFig.grabVideo.handle = uicontrol(gd.showContinuousVideoFig.handle,'Style','text',...
  'String','Not grabbing','Position',[1350 80 100 20]);

gd.showContinuousVideoFig.fpsText.handle = uicontrol(gd.showContinuousVideoFig.handle,'Style','text',...
  'String',[sprintf('fps = %2.2f',0)],'Position',[180 20 60 20]);


%% here's a figure for viewing a single well
gd.singleWellFig.handle = figure('Toolbar','none',...
  'Menubar', 'none',...
  'NumberTitle','Off',...
  'Name','showContinuousVideo:Single Well',...
  'Position',[10 600 500 500]);

gd.singleWellImage.handle = imagesc(zeros(gd.wellSize));
set(gca,'position',[0 0 1 1]);
colormap('gray')
axis off

hold on

gd.singleWellImageAlpha.handle = image(cat(3,...
  ones(gd.wellSize),zeros(gd.wellSize),zeros(gd.wellSize)));
gd.singleAlphaData = zeros(gd.wellSize);
set(gd.singleWellImageAlpha.handle,'AlphaData',gd.singleAlphaData);

% place some buttons and such in the figure

% first, find the well we're displaying in row/column coordinates
row = ceil((gd.wellToDisplay-1)/12) + 64;
col = mod((gd.wellToDisplay-1),12);
if ~col
  col = 12;
end

gd.singleWellFig.positionText.handle = uicontrol(gd.singleWellFig.handle,'Style','text',...
  'String',sprintf('Well (%c,%2d) / Position %2d',row,col,gd.wellToDisplay-1),...
  'Position',[5 5 120 15]);


%% here we show the thresholded difference image
gd.singleWellDifferenceFig.handle = figure('Toolbar','none',...
  'Menubar', 'none',...
  'NumberTitle','Off',...
  'Name','showContinuousVideo:Single Well Difference',...
  'Position',[560 600 500 500]);

gd.singleWellDifferenceImage.handle = imagesc(zeros(gd.wellSize));
set(gca,'position',[0 0 1 1]);
colormap('gray')
axis off

gd.singleWellDifferenceFig.thresholdSliderText.handle = uicontrol(gd.singleWellDifferenceFig.handle,'Style','text',...
  'String',['Threshold = ' num2str(gd.threshold*256)],'Position',[20 40 100 15]);
gd.singleWellDifferenceFig.thresholdSlider.handle = uicontrol(gd.singleWellDifferenceFig.handle,'Style','slider',...
  'Max',50,'Min',1,'Value',gd.threshold*256,'SliderStep',[.01 .2],'Position',[20 20 100 20],...
  'Callback',@setThreshold);

%% here we show the historical thresholded difference image
gd.singleWellDifferenceHistoryFig.handle = figure('Toolbar','none',...
  'Menubar', 'none',...
  'NumberTitle','Off',...
  'Name','showContinuousVideo:Single Well Difference',...
  'Position',[1110 600 500 500]);

gd.singleWellDifferenceHistoryImage.handle = imagesc(zeros(gd.wellSize));
set(gca,'position',[0 0 1 1]);
colormap('gray')
axis off

gd.singleWellDifferenceHistoryFig.fpsSliderText.handle = uicontrol(gd.singleWellDifferenceHistoryFig.handle,'Style','text',...
  'String',['Duration = ' num2str(gd.fpsFreq)],'Position',[20 40 100 15]);
gd.singleWellDifferenceHistoryFig.fpsSlider.handle = uicontrol(gd.singleWellDifferenceHistoryFig.handle,'Style','slider',...
  'Max',1000,'Min',25,'Value',gd.fpsFreq,'SliderStep',[.01 .2],'Position',[20 20 100 20],...
  'Callback',@setfpsFreq);

%% SUPPORT FUNCTIONS
function updateROIMask(hObject,eventData) % reads in the appropriate file corresponding to the ROI
global gd
stopCamera(hObject,eventData)
% load E:\Documents\MATLAB\Carlos\mask
load E:\Documents\MATLAB\mask
% load E:\Documents\MATLAB\mask
% load E:\Documents\MATLAB\Adam\96wellmaskblack\mask

gd.mask = mask;
gd.wellSize = sqrt(length(find(gd.mask == 2)));

% update the ROI
gd.ROIalphaData = zeros(size(gd.mask));
gd.ROIalphaData(gd.mask > 1) = .5;
set(gd.showContinuousVideoROIAlpha.handle,'AlphaData',gd.ROIalphaData);

% update the well highlight
gd.alphaData = zeros(size(gd.startImage));
gd.alphaData(gd.mask == gd.wellToDisplay) = .5;
set(gd.showContinuousVideoAlpha.handle,'AlphaData',gd.alphaData);

startCamera(hObject,eventData)

function grabVideo(hObject,eventData,handles)
global gd
gd.showContinuousVideoFig.grabVideo.handle = uicontrol(gd.showContinuousVideoFig.handle,'Style','text',...
  'String','Grabbing','Position',[1350 80 100 20]);
gd.videoFrame = 1;
gd.grabVideo = 1;

function setCameraGain(hObject,eventData,handles) % set camera gain
global gd vidprops

vidprops.Gain = fix(get(hObject,'Value'));
gd.vidprops.Gain = fix(get(hObject,'Value'));
set(gd.showContinuousVideoFig.gainSliderText.handle,'String',['Gain = ' num2str(gd.vidprops.Gain)]);
function setCameraShutter(hObject,eventData,handles)% set camera shutter
global gd vidprops

vidprops.Shutter = fix(get(hObject,'Value'));
gd.vidprops.Shutter = fix(get(hObject,'Value'));
set(gd.showContinuousVideoFig.shutterSliderText.handle,'String',['Shutter = ' num2str(gd.vidprops.Shutter)]);
function setfpsFreq(hObject,eventData,handles) % how often should we update the tickers/ROI?
global gd
gd.fpsFreq = fix(get(hObject,'Value'));
set(gd.singleWellDifferenceHistoryFig.fpsSliderText.handle,'String',...
  ['Duration = ' num2str(gd.fpsFreq)]);
function setThreshold(hObject,eventData,handles) % set the threshold for what is/isn't a changed pixel
global gd
gd.threshold = fix(get(hObject,'Value'))/256;
set(gd.singleWellDifferenceFig.thresholdSliderText.handle,'String',['Threshold = ' num2str(gd.threshold*256)]);
function updateWellToDisplay(hObject,eventData,handles) % deals with the request to watch a different well
global gd
% get the point we just clicked on
cp = fix(get(get(gd.showContinuousVideoImage.handle,'Parent'),'CurrentPoint'));

% update the well to show, so long as it isn't #1
% (which is the placeholder for all the non-well pixels in the image)
potentialWell = gd.mask(cp(3),cp(1));
if potentialWell > 1
  gd.wellToDisplay = potentialWell;
  gd.singleWellHistoryImage = zeros(gd.wellSize);
  % find the well we're displaying in row/column coordinates
  row = ceil((gd.wellToDisplay-1)/12) + 64;
  col = mod((gd.wellToDisplay-1),12);
  if ~col
    col = 12;
  end
  
  set(gd.singleWellFig.positionText.handle,...
    'String',sprintf('Well (%c,%d) / Position %2d',row,col,gd.wellToDisplay-1));
  gd.alphaData = zeros(size(gd.startImage));
  gd.alphaData(gd.mask == gd.wellToDisplay) = .5;
  set(gd.showContinuousVideoAlpha.handle,'AlphaData',gd.alphaData);
  
  
  
end
function closeAndDisconnect(hObject,eventdata,handles) % disconnect and close the window
global vid gd
% camera disconnection
stop(vid);
delete(vid);
clear vid
close(gd.showContinuousVideoFig.handle)
close(gd.singleWellFig.handle)
close(gd.singleWellDifferenceFig.handle)
close(gd.singleWellDifferenceHistoryFig.handle)
exit
function startCamera(hObject,eventData) % starts aquisition
global gd vid
im = getsnapshot(vid);
gd.previousSingleWellImage = reshape(im(gd.mask == gd.wellToDisplay),gd.wellSize,gd.wellSize);
gd.singleWellHistoryImage = zeros(gd.wellSize);
gd.lastframetime = now;
start(vid)
function stopCamera(hObject,eventdata,handles) % stops aquisition
global vid

flushdata(vid); % clean up the buffer
stop(vid)
function displayFramesContinuously(hObject,eventData,handles) % updates the image displays based on camera data
global gd vid

% grab a frame
[frame jnk metadata] = getdata(vid,1);

% display the image
set(gd.showContinuousVideoImage.handle,'Cdata',frame);

% display a single well
singleWellImage = reshape(frame(gd.mask == gd.wellToDisplay),gd.wellSize,gd.wellSize);
set(gd.singleWellImage.handle,'Cdata',singleWellImage);

if gd.grabVideo
  if gd.videoFrame ~= gd.numVideoFrames
    % update the video buffer
    gd.video(:,:,mod(gd.videoFrame-1,gd.numVideoFrames)+1) = frame;%singleWellImage;
    gd.videoTS(gd.videoFrame) = now;
    gd.videoFrame = gd.videoFrame+1;
  else
    gd.grabVideo = 0;
    showContinuousVideoFig.grabVideo.handle = uicontrol(gd.showContinuousVideoFig.handle,'Style','text',...
      'String','Not grabbing','Position',[1350 80 100 20]);

  end
end
% show the difference image, update for the next frame
singleWellDifferenceImage = im2bw(imabsdiff(gd.previousSingleWellImage,singleWellImage),gd.threshold);
set(gd.singleWellDifferenceImage.handle,'Cdata',singleWellDifferenceImage);
gd.previousSingleWellImage = singleWellImage;

% and the cumulative history of difference images
gd.singleWellHistoryImage = gd.singleWellHistoryImage + singleWellDifferenceImage;
set(gd.singleWellDifferenceHistoryImage.handle,'Cdata',gd.singleWellHistoryImage);

if ~mod(gd.numFrames,gd.fpsFreq)
  % reset the cumulative history of difference images
  gd.singleWellHistoryImage = zeros(size(gd.previousSingleWellImage));
  
  % display the fps
  gd.currentframetime = datenum(metadata.AbsTime);
  set(gd.showContinuousVideoFig.fpsText.handle,'String',sprintf('fps = %2.2f',...
    1./((gd.currentframetime - gd.lastframetime)*(86400/gd.fpsFreq))));
  gd.lastframetime = gd.currentframetime;

end

gd.numFrames = gd.numFrames + 1;

